<?php
 
ini_set('max_execution_time', 180);
 
// Check if a domain has been specified or not. 
if (!isset($_GET['url']) && $_GET['url'] == "") 
{
	header("Location: index.php?s=empty");
	die();
}

// Include base files for functions and classes 
require 'lib/config.php';

$domain = $_GET['url'];

if (check_domain($domain) != false) 
{
	$domain = check_domain($domain);
}
else
{
	header('HTTP/1.1 301 Moved Permanently');
	header("Location: ".$config['site_url']."/?s=error");
	die();
}

$data_present = $conn->query("SELECT * FROM sites where domain = '$domain'");
if($data_present->rowCount() <= 0)
{
	if($socket =@ fsockopen($domain, 80, $errno, $errstr, 30)) 
	{
		fclose($socket);
	}
	else
	{
		header("Location: index.php?s=error");
		die();
	}
}


if(($data_present->rowCount() > 0 && isset($_GET['update'])) || ($data_present->rowCount() <= 0))
{
	require 'lib/class.socialstats.php';
	require 'lib/class.analyzer.php';
	require 'lib/whois/whois.main.php';

	// Set some default veriables. 
	$data = array();

	// Get the domain to be reviewed
	$data['domain'] = $domain;

	// Get whois info 
	$whois = new Whois();
	$socialstats = new SocialStats('http://'.$data['domain']);
	$analyzer = new Analyzer($data['domain']);

	// get analyzer stats
	$analyzer_data = $analyzer->get_all();
	foreach ($analyzer_data as $key => $value) {
		$data[$key] = $value;
	}

	// get social stats
	$social_data = $socialstats->get_all();
	foreach ($social_data as $key => $value) {
		$data[$key] = $value;
	}

	$whois_data = $whois->Lookup($data['domain'],false);
	if(!isset($whois_data['regrinfo']['domain']['created']))
	{
		$data['domain_created'] = "Not Available";
	}
	else
	{
		$data['domain_created'] = $whois_data['regrinfo']['domain']['created'];
	}

	$whois_info = "";
	foreach($whois_data['rawdata'] as $key => $value)
	{
        	$whois_info .= $value."<br />";
    	}	
    	$data['whois_info'] = $whois_info;

    	$meta['title'] = htmlspecialchars(get_title( 'http://'.$data['domain'] ) );

    	$meta_data = get_meta_tags( 'http://'.$data['domain'] );
    	$meta['description'] = (isset( $meta_data['description'] )) ? htmlspecialchars($meta_data['description']) : 'No description found';
    	$meta['keywords'] = (isset( $meta_data['keywords'] )) ? htmlspecialchars($meta_data['keywords']) : 'No keywords found';

    	// var_dump($meta);
    	$sql = $conn->prepare("INSERT INTO meta_data (domain, title, description, keywords) 
    				VALUES ('". $data['domain'] ."', :title , :description , :keywords) 
    				ON DUPLICATE KEY UPDATE title= :title , description= :description , keywords= :keywords ");
    	$sql->execute($meta);

	$data['updated'] = time();

	if (isset($_GET['update']) && $_GET['update'] == "true") 
	{
		$update_sites = $conn->prepare($globals['update_query_sites']);
		$update_sites->execute($data);
	}
	else
	{
		$data['views'] = 1;
		$data['added'] = time();

		$insert_sites = $conn->prepare($globals['insert_query_sites']);
		$insert_sites->execute($data);
	}
}
else
{
	$data = $data_present->fetch();

	$sql = $conn->query('SELECT * FROM meta_data WHERE domain = "' . $data['domain'] . '"');
	$meta = $sql->fetch();

	// update view count 
	$conn->query("UPDATE sites SET views = views + 1 WHERE domain='" .$data['domain']."'");
}


// Get domain age
$data['domain_age'] = ($data['domain_created'] == "Not Available") ? $data['domain_created'] : domainAge($data['domain_created']);

$data['dmoz'] = ($data['dmoz'] == true) ? '<a href="'.$globals["dmoz_search"].$data["domain"].'">Listed</a>' : 'Not Listed';
$data['yahoo_directory'] = ($data['yahoo_directory'] == true) ? '<a href="'.$globals["yahoo_directory_search"].$data["domain"].'">Listed</a>' : 'Not Listed';

// Image url
$data['image_url'] = 'http://immediatenet.com/t/fs?Size=1024x768&URL=' . $data['domain'];

$data['self_url'] = $config['site_url']."/".$data['domain'];

$config['title'] = replace(array("domain" => $data['domain']), $config['review_title']);
$config['description'] = replace(array("domain" => $data['domain']), $config['review_description']);

// Create the view for user :)
$path = 'review.view.php';
include 'views/master.php';